// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef RECMEM_H
#define RECMEM_H

#include "meminterface.h"
#include "hardware.h"

class RecMemory : public MemInterface {
public:
	RecMemory(Hardware &h, RegistersBase &r, InterruptRaiser &i)
		: MemInterface(r, i, h, true) {}

	DWORD read_instruction(DWORD address) {
		DWORD physical = translate_i(address);
		if(physical == -1) {
			DEGUB("Page fault trying to read 0x%08X(%08X)\n", address, physical);
			throw page_fault_exception("Page fault!");
		}
		DWORD data = swapw(*(DWORD*)getphc(physical));
		MDEGUB(p_memdegub, "ri[%08X]%08X ", physical, data);
		return data;
	}
	void write_instruction(DWORD address, DWORD data) {	//hack
		DWORD physical = translate_i(address);
		if(physical == -1) {
			DEGUB("Page fault trying to write 0x%08X(%08X)\n", address, physical);
			throw rec_fatal_exception("Page fault!");
		}
		MDEGUB(p_memdegub, "wi[%08X]%08X ", physical, data);
		*(DWORD*)getphc(address) = swapw(data);
	}
	DWORD read_pia(DWORD pia) {
		MYASSERT(pia < MAIN_MEMORY_SIZE);
		return g::cache_enabled ? rw(pia) : swapw(MAKE(DWORD, mainmem[pia]));
	}
	void write_pia(DWORD pia, DWORD data) {
		MYASSERT(pia < MAIN_MEMORY_SIZE);
		if(g::cache_enabled) {
			ww(pia, data);
		} else {
			MAKE(DWORD, mainmem[pia]) = swapw(data);
		}
	}
};

#endif	//RECMEM_H
